# +-------------------------------------------------------------------------+
# | Config for DNSearch (Denwer Search)                                     |
# +-------------------------------------------------------------------------+
# | Copyright © Anton Sushchev aka Ant <http://forum.dklab.ru/users/Ant/>   |
# +-------------------------------------------------------------------------+


package Conf::DNSconf;

# Диск, с которого запущен сервер (для Win).
my $drive = chr( ( stat '.' )[ 0 ] + ord( 'A' ) );

################################################################################
#*******************************************************************************
#* НАСТРОЙКИ DNSearch
#*

# Общая (корневая) временная директория.
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$TMP_PATH = '/tmp/dnsearch';

# Пути для поиска.
# ~~~~~~~~~~~~~~~~

# Перечень директорий для поиска. Всё очень просто. Каждая запись состоит из нескольких частей:
# «номер записи => [ "название опции в форме", "путь для поиска", "путь для перехода к найденному" ],»
# Вы можете использовать этот механизм очень гибко. Вплоть до того, что выдаваться файлы будут
# через какой-нибудь сторонний скрипт (для ведения статистики).
%PATHS = (
	2 => [ "В «http://localhost/»"     , "/home/localhost/www/"     , "http://localhost"               ],
	3 => [ "В «$drive:/home/localhost»", "$drive:/home/localhost"   , "file:///$drive:/home/localhost" ],
	4 => [ "В «/home»"                 , "/home/"                   , "file:///$drive:\\home\\"        ],
	5 => [ "В «/usr»"                  , "/usr/"                    , "file:///$drive:/usr/"           ],
	6 => [ "В корне диска «$drive»"    , "/"                        , "file:///$drive:/"               ],
);

# Фильтрация поиска.
# ~~~~~~~~~~~~~~~~~~

# Поиск можно задавать оператором qr// (qr/^.*?\.shtml$/i).

# Перечень директорий в которых не нужно искать.
@NO_SEARCH_DIR = ( 'cgi', 'cgi-bin', 'cgi-glob' );

# Перечень файлов (или расширений) в которых нужно искать.
@YES_SEARCH_FILE = ( '.htm', '.html', '.shtml', '.xhtml' );

# Перечень файлов (или расширений) в которых не нужно искать.
@NO_SEARCH_FILE = ( );

# Формат вывода.
# ~~~~~~~~~~~~~~

# Количество обхватывающих символов по обеим сторонам от найденного слова для
# отображения в результатах. Обратите внимание, выделенные данные сохраняются
# в кэше (если кэш включён), а, следовательно, чем большее число Вы укажете,
# тем больше в итоге будет занимать кэш на диске. Учитывайте этот момент.
$RESULT_BORDER = 200;

# Количество результатов на одну страницу.
# «0» — без постраничного вывода (выводить всё сразу).
$RESULTS_PER_PAGE = 10;

# Кэширование результатов.
# ~~~~~~~~~~~~~~~~~~~~~~~~

# «0» — запрещает кэширование результатов. «1» — разрешает.
# Чтобы был возможет «поиск в найденном», необходимо включить эту опцию.
$CACHE_YES = 1;

# Путь к папке, где будет лежать кеш. Без «/» в конце!
$CACHE_PATH = $TMP_PATH.'/cache';

# Время в часах, сколько кэш считается валидным.
# «0» — кэш без ограничения по времени (настоятельно *не* рекомендуется).
$CACHE_MAX_TIME = 10;

# Критический размер кэша в мегабайтах, по превышению которого, он будет удалён.
# «0» - кэш без ограничения по размеру (настоятельно *не* рекомендуется).
$CACHE_MAX_SIZE = 10;

# Кэширование путей.
# ~~~~~~~~~~~~~~~~~~

# «0» — запрещает кэширование путей. «1» — разрешает.
$PATHS_CACHE = 1;

# Путь к папке, где будет лежать файл с закэшированными путями. Без «/» в конце!
$PATHS_CACHE_PATH = $TMP_PATH;

# Критический размер файла с закэшированными путями.
# Формат такой же, как и у $CACHE_MAX_SIZE.
$PATHS_CACHE_MAX_SIZE = 10;

# Время жизни $PATHS_CACHE.
# Формат такой же, как и у $CACHE_MAX_TIME.
$PATHS_CACHE_MAX_TIME = 10;

# Работа с архивами.
# ~~~~~~~~~~~~~~~~~~

# Перечень расширений, которые небходимо считать архивами.
# В файле «Conf/archive.types» содержатся расширения и
# соответствующие им пути к архиваторам для распаковки.
@ARCHIVE_FILE = ( '.chm', '.zip', '.rar' );

# Максимальный размер архивов для распаковки. В мегабайтах.
# Если размер архива превысит значение, то архив распакован
# не будет (соответственно, он будет пропущен при поиске).
# Если «0», то без ограничения.
$ARCHIVE_FILE_MAX_SIZE = 5;

# Путь к папке, где будут лежать распакованные файлы. Без «/» в конце!
# Точно такой же путь должен быть установлен в $VIEW_PATH в файле «viewer.pl».
$ARCH_PATH = $TMP_PATH.'/arch';

# Критический размер распакованных архивов.
# Формат такой же, как и у $CACHE_MAX_SIZE.
$ARCH_MAX_SIZE = 80;

# Ограничение на количество процессов.
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# Максимальное количество процессов, которые могут одновременно выполняться.
# «0» — без ограничения.
$MAX_PROCESS_NUMBER = 0;

# Путь к папке, где будет лежать файл с результирующим количеством процессов.
# Без «/» в конце!
$MAX_PROCESS_NUMBER_PATH = $TMP_PATH;

# Время жизни $MAX_PROCESS_NUMBER_PATH.
# Формат такой же, как и у $CACHE_MAX_TIME.
$MAX_PROCESS_NUMBER_TIME = 1;

#*
#* КОНЕЦ НАСТРОЕК DNSearch
#*******************************************************************************
################################################################################

# Экспортирует все функции в вызвавший пакет.
# Вызывается автоматически.
# © dk
sub import {
	while( my ( $k, $v ) = each( %{ __PACKAGE__."::" } ) ) {
		next if substr( $k , -1 ) eq ":" || grep { $k eq $_ } qw(BEGIN import);
		*{ caller()."::".$k } = $v;
	}
}

return 1;
