<?PHP

/* ====================
Seditio - Website engine
Copyright Neocrome
http://www.neocrome.net

[BEGIN_SED]
File=plugins/similarpages/similarpages.php
Version=170
Updated=2012-feb-26
Type=Plugin
Author=Amro
Description=The plugin displays a list of similar pages
[END_SED]

[BEGIN_SED_EXTPLUGIN]
Code=similarpages
Part=main
File=similarpages
Hooks=page.tags
Tags=page.tpl {PLUGIN_SIMILAR_PAGES}
Minlevel=0
Order=10
[END_SED_EXTPLUGIN]

==================== */

if (!defined('SED_CODE')) { die('Wrong URL.'); }

$cfg['plu_mask_similar_pages'] = "%3\$s"." : "."%1\$s"." ".$cfg['separator']." "."%2\$s"."<br />";
// %1\$s = Link to the category
// %2\$s = Link to the page
// %3\$s = Date

$sim_relevance = $cfg['plugin']['similarpages']['sim_relevance'];
$sim_maxcount = $cfg['plugin']['similarpages']['sim_maxcount'];
$sim_category = $cfg['plugin']['similarpages']['sim_category'];

$plu_empty = $L['None']."<br />";

/* ================== FUNCTIONS ================== */

function sed_get_similarpages($sim_relevance, $sim_maxcount, $sim_category, $mask)
	{
	global $L, $pag, $db_pages, $usr, $cfg, $sed_cat, $plu_empty;

  $sql_cat = "";
  if (!empty($sim_category)) { 
      $sim_category = explode(',', $sim_category);
      foreach($sim_category as $k => $i) {
         $i = rtrim(trim($i));  
         $mtch = $sed_cat[$i]['path'].".";
         $mtchlen = strlen($mtch);
         $catsub = array();
         $catsub[] = $i;
         @reset($sed_cat);
         while (list($j,$x) = each($sed_cat) ) {  if (substr($x['path'],0,$mtchlen)==$mtch) { $catsub[] = $j; } }
        }
      $sql_cat = "AND page_cat IN ('".implode("','", $catsub)."')";   
  }  
  
  $sql = sed_sql_query("SELECT page_id, page_alias, page_cat, page_title, page_date FROM $db_pages 
                        WHERE page_state=0 AND page_cat NOT LIKE 'system' ".$sql_cat." AND page_id != ".$pag['page_id']." AND MATCH (page_title) 
                        AGAINST ('".sed_sql_prep($pag['page_title'])."') > $sim_relevance 
                        ORDER BY page_date DESC LIMIT $sim_maxcount");

  while ($row = sed_sql_fetchassoc($sql))
  	{    
    	if (sed_auth('page', $row['page_cat'], 'R'))
  			{
  			$row['page_pageurl'] = (empty($row['page_alias'])) ? "page.php?id=".$row['page_id'] : "page.php?al=".$row['page_alias'];
  		  $res .= sprintf($mask,
  			"<a href=\"list.php?c=".$row['page_cat']."\">".$sed_cat[$row['page_cat']]['title']."</a>",
  			"<a href=\"".$row['page_pageurl']."\">".sed_cc(sed_cutstring(stripslashes($row['page_title']), 36))."</a>",
  			date($cfg['formatyearmonthday'], $row['page_date'] + $usr['timezone'] * 3600)
  				);
  			}
  		}

	$res = (empty($res)) ? $plu_empty : $res;

	return($res);
	}

/* ============= */

if ($sim_maxcount > 0 && !$cfg['disable_page']) { 
  $t-> assign(array(
	   "PLUGIN_SIMILAR_PAGES" => sed_get_similarpages($sim_relevance, $sim_maxcount, $sim_category, $cfg['plu_mask_similar_pages']) 
	));
}

